#include <stdint.h>
#include <stdbool.h>

// TFT module connections
sbit FT800_RST at LATC.B1;
sbit FT800_CS at LATC.B2;
sbit FT800_RST_Direction at TRISC.B1;
sbit FT800_CS_Direction at TRISC.B2;
// End TFT module connections

sbit _CLK at LATG.B6;
sbit _SDO at LATG.B8;

sbit _CLK_DIR at TRISG.B6;
sbit _SDO_DIR at TRISG.B8;

typedef enum {
  COM = 1,
  DAT = 2
}DC;

void ILI_SPI()
{
  FT800_CS = 1;
  ON__SPI2CON_bit = 0;
  _CLK_DIR = 0;
  _SDO_DIR = 0;
}

void Ft_Gpu_Hal_Powercycle(bool dir)
{
  if (dir)
  {
    FT800_RST = 0;
    Delay_ms(20);
    FT800_RST = 1;
    Delay_ms(20);
  }
  else
  {
    FT800_RST = 1;
    Delay_ms(20);
    FT800_RST = 0;
    Delay_ms(20);
  }
}

void ILI_CS_send(unsigned short _data)
{
  unsigned char m = 0x80, i;
  for(i=0; i < 8; i++)
  {
    _CLK = 0;
    Delay_1us;
    if(_data & m)
    {
      _SDO = 1;
    }
    else
    {
      _SDO = 0;
    }
    Delay_1us;
    _CLK = 1;
    m = m >> 1;
    Delay_1us;
    _CLK = 0;
  }
}

void CS_ILI(uint8_t mode)
{
  switch (mode)
  {
  case 0:
    {
      FT800_CS = 0;
      
      ILI_CS_Send((((_FT800_REG_GPIO >> 16) & 0xBF) | 0x80));
      ILI_CS_Send((_FT800_REG_GPIO & 0xFF00) >> 8);
      ILI_CS_Send((_FT800_REG_GPIO & 0xFF));
      
      ILI_CS_Send(0x00);
      
      FT800_CS = 1;
      break;
    }
  case 1:
    {
      FT800_CS = 0;
      Delay_1us;
      ILI_CS_Send((((_FT800_REG_GPIO >> 16) & 0xBF) | 0x80));
      ILI_CS_Send((_FT800_REG_GPIO & 0xFF00) >> 8);
      ILI_CS_Send((_FT800_REG_GPIO & 0xFF));
      Delay_1us;
      ILI_CS_Send(0x83);
      Delay_1us;
      FT800_CS = 1;
      Delay_1us;
      _SDO = 0;
      _CLK = 0;

      break;
    }
  }
}

void ILI_Send(DC type, uint8_t _data)
{
  uint8_t m=0x80;
  uint8_t i;
  if(type == COM)
  {
    _CLK = 0;
    Delay_1us;
    _SDO = 0;
    Delay_1us;
    _CLK = 1;
    Delay_1us;
  }
  else if(type == DAT)
  {
    _CLK = 0;
    Delay_1us;
    _SDO = 1;
    Delay_1us;
    _CLK = 1;
    Delay_1us;
  }
  for(i=0; i<8; i++)
  {
    _CLK = 0;
    Delay_1us;
    if(_data & m)
    {
      _SDO = 1;
    }
    else
    {
      _SDO = 0;
    }
    Delay_1us;
    _CLK = 1;
    m = m >> 1;
  }
  Delay_ms(1);
}

void ILI_init()
{
  ILI_SPI();
  Delay_ms(100);
  CS_ILI(0);
  ILI_Send(COM, 0x01);                                                                   //software reset
  Delay_ms(5);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0x28);                                                                   // display off
  CS_ILI(1);
  //---------------------------------------------------------

  CS_ILI(0);
  ILI_Send(COM, 0xcf);
  ILI_Send(DAT, 0x00);
  ILI_Send(DAT, 0x81);
  ILI_Send(DAT, 0x30);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xed);
  ILI_Send(DAT, 0x64);
  ILI_Send(DAT, 0x03);
  ILI_Send(DAT, 0x12);
  ILI_Send(DAT, 0x81);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xe8);
  ILI_Send(DAT, 0x85);
  ILI_Send(DAT, 0x01);
  ILI_Send(DAT, 0x79);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xcb);
  ILI_Send(DAT, 0x39);
  ILI_Send(DAT, 0x2c);
  ILI_Send(DAT, 0x00);
  ILI_Send(DAT, 0x34);
  ILI_Send(DAT, 0x02);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xF6);                                                                   //Interface Control
  ILI_Send(DAT, 0x01);
  ILI_Send(DAT, 0x00);
  ILI_Send(DAT, 0x06);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xf7);
  ILI_Send(DAT, 0x20);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xea);
  ILI_Send(DAT, 0x06);
  ILI_Send(DAT, 0x00);
  CS_ILI(1);

  //------------power control------------------------------
  CS_ILI(0);
  ILI_Send(COM, 0xc0);                                                                   //power control
  ILI_Send(DAT, 0x26);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xc1);                                                                   //power control
  ILI_Send(DAT, 0x11);
  CS_ILI(1);
  //--------------VCOM ---------
  CS_ILI(0);
  ILI_Send(COM, 0xc5);                                                                   //vcom control
  ILI_Send(DAT, 0x35);                                                                      //35
  ILI_Send(DAT, 0x3E);                                                                      //3E
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xc7);                                                                   //vcom control
  ILI_Send(DAT, 0xBE);                                                                      // 0x94
  CS_ILI(1);

  //------------memory access control------------------------
  CS_ILI(0);
  ILI_Send(COM, 0x36);                                                                   // memory access control
  ILI_Send(DAT, 0x40);                                                                      //0048    my,mx,mv,ml,BGR,mh,0.0
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0x3a);                                                                   // pixel format set
  ILI_Send(DAT, 0x60);                                                                      //18bit /pixel
  CS_ILI(1);
  //----------------- frame rate------------------------------
  CS_ILI(0);
  ILI_Send(COM, 0xb0);                                                                   //RGB Interface Signal Control
  ILI_Send(DAT, 0xC0);                                                                      //0x1c0 DE mode
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xb1);                                                                   //  frame rate
  ILI_Send(DAT, 0x00);
  ILI_Send(DAT, 0x1B);                                                                      //70
  CS_ILI(1);

  //----------------Gamma---------------------------------
  CS_ILI(0);
  ILI_Send(COM, 0xf2);                                                                   // 3Gamma Function Disable
  ILI_Send(DAT, 0x02);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0x26);
  ILI_Send(DAT, 0x01);                                                                      //  gamma set 4 gamma curve 01/02/04/08
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xE0);                                                                   //positive gamma correction
  ILI_Send(DAT, 0x1f);
  ILI_Send(DAT, 0x1a);
  ILI_Send(DAT, 0x18);
  ILI_Send(DAT, 0x0a);
  ILI_Send(DAT, 0x0f);
  ILI_Send(DAT, 0x06);
  ILI_Send(DAT, 0x45);
  ILI_Send(DAT, 0x87);
  ILI_Send(DAT, 0x32);
  ILI_Send(DAT, 0x0a);
  ILI_Send(DAT, 0x07);
  ILI_Send(DAT, 0x02);
  ILI_Send(DAT, 0x07);
  ILI_Send(DAT, 0x05);
  ILI_Send(DAT, 0x00);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0xE1);                                                                   //negamma correction
  ILI_Send(DAT, 0x00);
  ILI_Send(DAT, 0x25);
  ILI_Send(DAT, 0x27);
  ILI_Send(DAT, 0x05);
  ILI_Send(DAT, 0x10);
  ILI_Send(DAT, 0x09);
  ILI_Send(DAT, 0x3a);
  ILI_Send(DAT, 0x78);
  ILI_Send(DAT, 0x4d);
  ILI_Send(DAT, 0x05);
  ILI_Send(DAT, 0x18);
  ILI_Send(DAT, 0x0d);
  ILI_Send(DAT, 0x38);
  ILI_Send(DAT, 0x3a);
  ILI_Send(DAT, 0x1f);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0x11);                                                                   //sleep out
  Delay_ms(100);
  CS_ILI(1);

  CS_ILI(0);
  ILI_Send(COM, 0x29);                                                                   // display on
  Delay_ms(50);
  CS_ILI(1);
}