#ifndef MYPROJECT2_OBJECTS
#define MYPROJECT2_OBJECTS

#include "FT800_Types.h"

typedef struct Screen TScreen;

typedef unsigned long TPointer;

typedef struct tagObjInfo {
  void     *Obj;
  char     Type;
  char     Order;
  char     Flags;

  char     HitTag;
  int      HitX;
  int      HitY;
} TObjInfo;

typedef struct tagTouchStat {
  char Pressed;

  char Tag;
  int  X;
  int  Y;

  TObjInfo ActObjInfo;
} TTouchStat;

typedef void (*TDrawHandler)(TPointer aObj);

typedef void (*TEvtAction)();

typedef struct tagEvtSound {
  char SndAct;
  char Effect;
  char Pitch;
  char Volume;
} TEvtSound;

typedef const struct tagCEvent {
  TEvtAction Action;
  TEvtSound  Sound;
} TCEvent;

typedef struct tagEvent {
  TEvtAction Action;
  TEvtSound  Sound;
} TEvent;

typedef const struct tagCRect {
  int Left;
  int Top;
  int Width;
  int Height;
} TCRect;

typedef struct tagRect {
  int Left;
  int Top;
  int Width;
  int Height;
} TRect;

typedef struct tagImage {
  TScreen         *OwnerScreen;
  char            Order;
  char            Visible;
  char            Opacity;
  char            Tag;
  int             Left;
  int             Top;
  int             Width;
  int             Height;
  const code char *Picture_Name;
  char            Picture_Type;
  char            Picture_Ratio;
  unsigned int    Blend_Color;
  long            Source;
  int             RotationAngle;
  int             RotationCenterLeft;
  int             RotationCenterTop;
  float           ScaleX;
  float           ScaleY;
  char            Active;
  TEvent          *OnUp;
  TEvent          *OnDown;
  TEvent          *OnClick;
  TEvent          *OnPress;
} TImage;

typedef struct tagCircle {
  TScreen      *OwnerScreen;
  char         Order;
  char         Visible;
  char         Opacity;
  char         Tag;
  int          Left;
  int          Top;
  int          Radius;
  char         Pen_Width;
  unsigned int Pen_Color;
  unsigned int Color;
  unsigned int Press_Color;
  char         Active;
  TEvent       *OnUp;
  TEvent       *OnDown;
  TEvent       *OnClick;
  TEvent       *OnPress;
} TCircle;

typedef struct tagBox {
  TScreen      *OwnerScreen;
  char         Order;
  char         Visible;
  char         Opacity;
  char         Tag;
  int          Left;
  int          Top;
  int          Width;
  int          Height;
  char         Pen_Width;
  unsigned int Pen_Color;
  unsigned int Color;
  unsigned int Press_Color;
  unsigned int ColorTo;
  unsigned int Press_ColorTo;
  char         Gradient;
  char         Active;
  TEvent       *OnUp;
  TEvent       *OnDown;
  TEvent       *OnClick;
  TEvent       *OnPress;
} TBox;

typedef struct tagEveSpinner {
  TScreen      *OwnerScreen;
  char         Tag;
  int          Left;
  int          Top;
  unsigned int Color;
  char         Style;
  char         Scale;
} TEveSpinner;

struct Screen {
  unsigned int   Color;
  unsigned int   Width;
  unsigned int   Height;
  unsigned short ObjectsCount;
  unsigned short ImagesCount;
  TImage         *const code *Images;
  unsigned short CirclesCount;
  TCircle        *const code *Circles;
  unsigned short BoxesCount;
  TBox           *const code *Boxes;
  unsigned short EveSpinnersCount;
  TEveSpinner    *const code *EveSpinners;
  unsigned long  DynResStart;
  unsigned short Active;
  unsigned short **EveAnimation;
  unsigned short SniffObjectEvents;
  TEvent         *OnUp;
  TEvent         *OnDown;
  TEvent         *OnTagChange;
  TEvent         *OnPress;
};


// Object type constants
// Usage: VTFT stack internally
extern const VTFT_OT_IMAGE;
extern const VTFT_OT_CIRCLE;
extern const VTFT_OT_BOX;
extern const VTFT_OT_EVESPINNER;
// ~Object type constants

// Event type constants
// Usage: OnEvent
extern const VTFT_EVT_UP;
extern const VTFT_EVT_DOWN;
extern const VTFT_EVT_CLICK;
extern const VTFT_EVT_PRESS;
// ~Event type constants

// Sound action constants
// Usage: sound event action property and ProcessEvent
extern const VTFT_SNDACT_NONE;
extern const VTFT_SNDACT_PLAY;
extern const VTFT_SNDACT_STOP;
// ~Sound action constants

// Resource loading constants.
// Usage: DrawScreenO and LoadCurrentScreenResToGRAM
extern const VTFT_LOAD_RES_NONE;
extern const VTFT_LOAD_RES_STATIC;
extern const VTFT_LOAD_RES_DYNAMIC;
extern const VTFT_LOAD_RES_ALL;
// ~Resource loading constants

// Display effect constants
// Usage: DrawScreenO
extern const VTFT_DISPLAY_EFF_NONE;
extern const VTFT_DISPLAY_EFF_LIGHTS_FADE;
extern const VTFT_DISPLAY_EFF_LIGHTS_OFF;
// ~Display effect constants

// Stack flags
// Usage: internally used by VTFT stack
extern const VTFT_INT_REPAINT_ON_DOWN;
extern const VTFT_INT_REPAINT_ON_UP;
extern const VTFT_INT_BRING_TO_FRONT;
extern const VTFT_INT_INTRINSIC_CLICK_EFF;
// ~Stack flags

// Table of object draw handlers
// Use object type constants to access coresponding object draw handler
extern const TPointer DrawHandlerTable[44];
// ~Table of draw handler pointers

// Table of animations
extern void *ScreensEveAnimationTable[2];
// ~Table of animations


// Default configuration parameters
extern const TFT800PWM            VTFT_FT800_CONFIG_PWM;
extern const TFT800GPIO           VTFT_FT800_CONFIG_GPIO;
extern const TFT800Sound          VTFT_FT800_CONFIG_SOUND;
extern const TFT800Audio          VTFT_FT800_CONFIG_AUDIO;
extern const TFT800Display        VTFT_FT800_CONFIG_DISPLAY;
extern const TFT800Interrupt      VTFT_FT800_CONFIG_INTERRUPT;

extern TTouchStat TouchS;

extern TScreen Screen1;

extern TCircle     Circle1;
extern TEvent      Circle1_OnClick;
extern TCircle     Circle4;
extern TEvent      Circle4_OnClick;
extern TBox        Box1;
extern TEvent      Box1_OnClick;
extern TBox        Box2;
extern TCircle     Circle3;
extern TEvent      Circle3_OnClick;
extern TCircle     Circle2;
extern TEvent      Circle2_OnClick;
extern TEveSpinner EveSpinner1;

extern TCircle     *const code Screen1_Circles[4];
extern TBox        *const code Screen1_Boxes[2];
extern TEveSpinner *const code Screen1_EveSpinners[1];

extern TScreen Screen2;

extern TImage Image1;
extern TEvent Image1_OnClick;

extern TImage *const code Screen2_Images[1];

extern TScreen *CurrentScreen;

/////////////////////////
// User Event Handlers
void R_Home();
void R_Img();
/////////////////////////

/////////////////////////////////
// Captions

/////////////////////////////////
// Event Descriptors 
extern TEvent Circle1_OnUpOnClick;
extern TEvent Circle4_OnUpOnClick;
extern TEvent Box1_OnUpOnClick;
extern TEvent Circle3_OnUpOnClick;
extern TEvent Circle2_OnUpOnClick;
extern TEvent Image1_OnUpOnClick;
/////////////////////////////////

void DrawScreenO(TScreen *aScreen, char aOptions);
void DrawScreen(TScreen *aScreen);
void DisableEveAnimation(TScreen *AScreen);
void EnableEveAnimation(TScreen *AScreen, void * AEveAnimation);
void DrawImage(TImage *AImage);
void DrawCircle(TCircle *ACircle);
void DrawBox(TBox *ABox);
char DrawEveSpinner(TEveSpinner *AEveSpinner);
void ProcessVTFTStack();
void InitVTFTStack();

#endif
